# use separate environment with ROS installed
import rosbag
import cv2
import os
from cv_bridge import CvBridge

for i in range(1, 9):
    # Paths for extracted data
    output_dir = f"/home/zihzhu/data/Datasets/rpngar/table_{i:02d}"
    os.makedirs(output_dir, exist_ok=True)
    for subdir in ["rgb", "depth"]:
        os.makedirs(os.path.join(output_dir, subdir), exist_ok=True)

    imu_file = open(os.path.join(output_dir, "imu.txt"), "w")
    gt_file = open(os.path.join(output_dir, "gt.txt"), "w")
    gt_ns_file = open(os.path.join(output_dir, "gt_ns.txt"), "w")
    gt_ns_csv_file = open(os.path.join(output_dir, "gt_ns.csv"), "w")

    # Initialize ROS bag and OpenCV bridge
    bag = rosbag.Bag(f"/home/zihzhu/data/Datasets/rpngar_bags/table_{i:02d}.bag", "r")
    bridge = CvBridge()
    for topic, msg, _ in bag.read_messages():
        # Use the header stamp from the message for the timestamp
        timestamp_ns = int(msg.header.stamp.to_nsec())
        
        if topic == "/d455/color/image_raw":
            image = bridge.imgmsg_to_cv2(msg, "bgr8")
            filename = f"rgb/{timestamp_ns}.png"
            cv2.imwrite(os.path.join(output_dir, filename), image)
        
        elif topic == "/d455/aligned_depth_to_color/image_raw":
            depth_image = bridge.imgmsg_to_cv2(msg, "16UC1")
            filename = f"depth/{timestamp_ns}.png"
            cv2.imwrite(os.path.join(output_dir, filename), depth_image)
        
        elif topic == "/d455/imu":
            wx = msg.angular_velocity.x
            wy = msg.angular_velocity.y
            wz = msg.angular_velocity.z
            ax = msg.linear_acceleration.x
            ay = msg.linear_acceleration.y
            az = msg.linear_acceleration.z
            imu_file.write(f"{timestamp_ns},{wx},{wy},{wz},{ax},{ay},{az}\n")
        
        elif topic == "/d455/rigidbody":
            # continue
            tx = msg.pose.position.x
            ty = msg.pose.position.y
            tz = msg.pose.position.z
            qx = msg.pose.orientation.x
            qy = msg.pose.orientation.y
            qz = msg.pose.orientation.z
            qw = msg.pose.orientation.w
            gt_file.write(f"{timestamp_ns/1e9} {tx} {ty} {tz} {qx} {qy} {qz} {qw}\n")
            gt_ns_file.write(f"{timestamp_ns} {tx} {ty} {tz} {qx} {qy} {qz} {qw}\n")
            gt_ns_csv_file.write(f"{timestamp_ns},{tx},{ty},{tz},{qx},{qy},{qz},{qw}\n")

    imu_file.close()
    gt_file.close()
    gt_ns_file.close()
    gt_ns_csv_file.close()
    bag.close()

    print("Extraction complete! Data saved in", output_dir)
